/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.object;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.StringDescription;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.hamcrest.object.HasToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasToStringTest
extends AbstractMatcherTest {
    private static final String TO_STRING_RESULT = "toString result";
    private static final Object ARG = new Object(){

        public String toString() {
            return HasToStringTest.TO_STRING_RESULT;
        }
    };

    @Override
    protected Matcher<?> createMatcher() {
        return HasToString.hasToString((Matcher)IsEqual.equalTo((Object)"irrelevant"));
    }

    public void testPassesResultOfToStringToNestedMatcher() {
        MatcherAssert.assertThat((Object)ARG, (Matcher)HasToString.hasToString((Matcher)IsEqual.equalTo((Object)TO_STRING_RESULT)));
        MatcherAssert.assertThat((Object)ARG, (Matcher)IsNot.not((Matcher)HasToString.hasToString((Matcher)IsEqual.equalTo((Object)"OTHER STRING"))));
    }

    public void testProvidesConvenientShortcutForHasToStringEqualTo() {
        MatcherAssert.assertThat((Object)ARG, (Matcher)HasToString.hasToString((String)TO_STRING_RESULT));
        MatcherAssert.assertThat((Object)ARG, (Matcher)IsNot.not((Matcher)HasToString.hasToString((String)"OTHER STRING")));
    }

    public void testHasReadableDescription() {
        Matcher toStringMatcher = IsEqual.equalTo((Object)TO_STRING_RESULT);
        Matcher matcher = HasToString.hasToString((Matcher)toStringMatcher);
        HasToStringTest.assertEquals((String)("with toString() " + HasToStringTest.descriptionOf(toStringMatcher)), (String)HasToStringTest.descriptionOf(matcher));
    }

    public void testMismatchContainsToStringValue() {
        String expectedMismatchString = "toString() was \"Cheese\"";
        HasToStringTest.assertMismatchDescription(expectedMismatchString, HasToString.hasToString((String)TO_STRING_RESULT), "Cheese");
    }

    private static String descriptionOf(Matcher<?> matcher) {
        return StringDescription.asString(matcher);
    }
}

